/*
Half-Life MAP viewing utility.
Copyright (C) 2003  Ryan Samuel Gregg

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#pragma once

#include "stdafx.h"
#include "Frustum.h"
#include "Camera.h"
#include "TextureManager.h"
#include "WorldObject.h"
#include "World.h"
#include "PointFile.h"

__gc class CEngine
{
private:
	// Handles
	HWND hWND;
	HDC hDC;
	HGLRC hGLRC;

	// Engine
	bool bRender;

	// Resources
	unsigned int iFontBase;

	// Movement
	Vertex2i vMouseOld;
	Vertex2i vMouseNew;
	bool bMousePressed;

	bool bW;
	bool bA;
	bool bS;
	bool bD;
	bool bShift;
	bool bUp;
	bool bDown;
	bool bRight;
	bool bLeft;
	
	// World
	CConfig *Config;
	CFrustum *Frustum;
	CCamera *Camera;
	CTextureManager *TextureManager;
	CWorldObject *HighlightObject;
	CWorld *World;
	CPointFile *PointFile;

	// Parent
	CRichTextBox *txtConsole;

public:
	CEngine(CConfig *Config, CRichTextBox *txtConsole);

	bool Initialize(HWND hWND);
	void Destroy();

	void Resize(int iWidth, int iHeight);

	void Paint();

	void LoadTextures();
	void DestroyTextures();

	void EnterRenderLoop();
	void ExitRenderLoop();

	void SetWorld(CWorld *World, CTextureManager *TextureManager);
	CTextureManager *GetTextureManager();
	void SetHighlightObject(CWorldObject *HighlightObject);
	void SetPointFile(CPointFile *PointFile);
	void UpdateTextureFilter();
	void SetMousePosition(int X, int Y);
	void SetMousePressed(bool bMousePressed);
	void SetKeyPressed(System::Windows::Forms::Keys Key, bool bKeyPressed);

	bool TestExtension(String *sExtension);

private:
	void MakeCurrent();
	void MakeNotCurrent();

	void BuildFont(String *FontName);
	void DestroyFont();

	void PreRenderLoop();

	void ClearBuffers();
	void MoveCamera();
	void SetCamera();
	void CullScene();
	void StartScene();
	void EndScene();
	void DrawScene();
	void Start2D();
	void DrawInfo();
	void RenderText(String *Text, int X, int Y, Color3uc Color);
	void End2D();
	void RenderToScreen();
};